<?php

namespace App\Services;

class TimeZones
{
    protected static $timeZones = [
        ['id' => 'Pacific/Midway', 'text' => '(UTC-11:00) Midway'],
        ['id' => 'Pacific/Niue', 'text' => '(UTC-11:00) Niue'],
        ['id' => 'Pacific/Pago_Pago', 'text' => '(UTC-11:00) Pago Pago'],
        ['id' => 'America/Adak', 'text' => '(UTC-10:00) Adak'],
        ['id' => 'Pacific/Honolulu', 'text' => '(UTC-10:00) Honolulu'],
        ['id' => 'Pacific/Johnston', 'text' => '(UTC-10:00) Johnston'],
        ['id' => 'Pacific/Rarotonga', 'text' => '(UTC-10:00) Rarotonga'],
        ['id' => 'Pacific/Tahiti', 'text' => '(UTC-10:00) Tahiti'],
        ['id' => 'Pacific/Marquesas', 'text' => '(UTC-09:30) Marquesas'],
        ['id' => 'America/Anchorage', 'text' => '(UTC-09:00) Anchorage'],
        ['id' => 'Pacific/Gambier', 'text' => '(UTC-09:00) Gambier'],
        ['id' => 'America/Juneau', 'text' => '(UTC-09:00) Juneau'],
        ['id' => 'America/Nome', 'text' => '(UTC-09:00) Nome'],
        ['id' => 'America/Sitka', 'text' => '(UTC-09:00) Sitka'],
        ['id' => 'America/Yakutat', 'text' => '(UTC-09:00) Yakutat'],
        ['id' => 'America/Dawson', 'text' => '(UTC-08:00) Dawson'],
        ['id' => 'America/Los_Angeles', 'text' => '(UTC-08:00) Los Angeles'],
        ['id' => 'America/Metlakatla', 'text' => '(UTC-08:00) Metlakatla'],
        ['id' => 'Pacific/Pitcairn', 'text' => '(UTC-08:00) Pitcairn'],
        ['id' => 'America/Santa_Isabel', 'text' => '(UTC-08:00) Santa Isabel'],
        ['id' => 'America/Tijuana', 'text' => '(UTC-08:00) Tijuana'],
        ['id' => 'America/Vancouver', 'text' => '(UTC-08:00) Vancouver'],
        ['id' => 'America/Whitehorse', 'text' => '(UTC-08:00) Whitehorse'],
        ['id' => 'America/Boise', 'text' => '(UTC-07:00) Boise'],
        ['id' => 'America/Cambridge_Bay', 'text' => '(UTC-07:00) Cambridge Bay'],
        ['id' => 'America/Chihuahua', 'text' => '(UTC-07:00) Chihuahua'],
        ['id' => 'America/Creston', 'text' => '(UTC-07:00) Creston'],
        ['id' => 'America/Dawson_Creek', 'text' => '(UTC-07:00) Dawson Creek'],
        ['id' => 'America/Denver', 'text' => '(UTC-07:00) Denver'],
        ['id' => 'America/Edmonton', 'text' => '(UTC-07:00) Edmonton'],
        ['id' => 'America/Hermosillo', 'text' => '(UTC-07:00) Hermosillo'],
        ['id' => 'America/Inuvik', 'text' => '(UTC-07:00) Inuvik'],
        ['id' => 'America/Mazatlan', 'text' => '(UTC-07:00) Mazatlan'],
        ['id' => 'America/Ojinaga', 'text' => '(UTC-07:00) Ojinaga'],
        ['id' => 'America/Phoenix', 'text' => '(UTC-07:00) Phoenix'],
        ['id' => 'America/Shiprock', 'text' => '(UTC-07:00) Shiprock'],
        ['id' => 'America/Yellowknife', 'text' => '(UTC-07:00) Yellowknife'],
        ['id' => 'America/Bahia_Banderas', 'text' => '(UTC-06:00) Bahia Banderas'],
        ['id' => 'America/Belize', 'text' => '(UTC-06:00) Belize'],
        ['id' => 'America/North_Dakota/Beulah', 'text' => '(UTC-06:00) Beulah'],
        ['id' => 'America/Cancun', 'text' => '(UTC-06:00) Cancun'],
        ['id' => 'America/North_Dakota/Center', 'text' => '(UTC-06:00) Center'],
        ['id' => 'America/Chicago', 'text' => '(UTC-06:00) Chicago'],
        ['id' => 'America/Costa_Rica', 'text' => '(UTC-06:00) Costa Rica'],
        ['id' => 'Pacific/Easter', 'text' => '(UTC-06:00) Easter'],
        ['id' => 'America/El_Salvador', 'text' => '(UTC-06:00) El Salvador'],
        ['id' => 'Pacific/Galapagos', 'text' => '(UTC-06:00) Galapagos'],
        ['id' => 'America/Guatemala', 'text' => '(UTC-06:00) Guatemala'],
        ['id' => 'America/Indiana/Knox', 'text' => '(UTC-06:00) Knox'],
        ['id' => 'America/Managua', 'text' => '(UTC-06:00) Managua'],
        ['id' => 'America/Matamoros', 'text' => '(UTC-06:00) Matamoros'],
        ['id' => 'America/Menominee', 'text' => '(UTC-06:00) Menominee'],
        ['id' => 'America/Merida', 'text' => '(UTC-06:00) Merida'],
        ['id' => 'America/Mexico_City', 'text' => '(UTC-06:00) Mexico City'],
        ['id' => 'America/Monterrey', 'text' => '(UTC-06:00) Monterrey'],
        ['id' => 'America/North_Dakota/New_Salem', 'text' => '(UTC-06:00) New Salem'],
        ['id' => 'America/Rainy_River', 'text' => '(UTC-06:00) Rainy River'],
        ['id' => 'America/Rankin_Inlet', 'text' => '(UTC-06:00) Rankin Inlet'],
        ['id' => 'America/Regina', 'text' => '(UTC-06:00) Regina'],
        ['id' => 'America/Resolute', 'text' => '(UTC-06:00) Resolute'],
        ['id' => 'America/Swift_Current', 'text' => '(UTC-06:00) Swift Current'],
        ['id' => 'America/Tegucigalpa', 'text' => '(UTC-06:00) Tegucigalpa'],
        ['id' => 'America/Indiana/Tell_City', 'text' => '(UTC-06:00) Tell City'],
        ['id' => 'America/Winnipeg', 'text' => '(UTC-06:00) Winnipeg'],
        ['id' => 'America/Atikokan', 'text' => '(UTC-05:00) Atikokan'],
        ['id' => 'America/Bogota', 'text' => '(UTC-05:00) Bogota'],
        ['id' => 'America/Cayman', 'text' => '(UTC-05:00) Cayman'],
        ['id' => 'America/Detroit', 'text' => '(UTC-05:00) Detroit'],
        ['id' => 'America/Grand_Turk', 'text' => '(UTC-05:00) Grand Turk'],
        ['id' => 'America/Guayaquil', 'text' => '(UTC-05:00) Guayaquil'],
        ['id' => 'America/Havana', 'text' => '(UTC-05:00) Havana'],
        ['id' => 'America/Indiana/Indianapolis', 'text' => '(UTC-05:00) Indianapolis'],
        ['id' => 'America/Iqaluit', 'text' => '(UTC-05:00) Iqaluit'],
        ['id' => 'America/Jamaica', 'text' => '(UTC-05:00) Jamaica'],
        ['id' => 'America/Lima', 'text' => '(UTC-05:00) Lima'],
        ['id' => 'America/Kentucky/Louisville', 'text' => '(UTC-05:00) Louisville'],
        ['id' => 'America/Indiana/Marengo', 'text' => '(UTC-05:00) Marengo'],
        ['id' => 'America/Kentucky/Monticello', 'text' => '(UTC-05:00) Monticello'],
        ['id' => 'America/Montreal', 'text' => '(UTC-05:00) Montreal'],
        ['id' => 'America/Nassau', 'text' => '(UTC-05:00) Nassau'],
        ['id' => 'America/New_York', 'text' => '(UTC-05:00) New York'],
        ['id' => 'America/Nipigon', 'text' => '(UTC-05:00) Nipigon'],
        ['id' => 'America/Panama', 'text' => '(UTC-05:00) Panama'],
        ['id' => 'America/Pangnirtung', 'text' => '(UTC-05:00) Pangnirtung'],
        ['id' => 'America/Indiana/Petersburg', 'text' => '(UTC-05:00) Petersburg'],
        ['id' => 'America/Port-au-Prince', 'text' => '(UTC-05:00) Port-au-Prince'],
        ['id' => 'America/Thunder_Bay', 'text' => '(UTC-05:00) Thunder Bay'],
        ['id' => 'America/Toronto', 'text' => '(UTC-05:00) Toronto'],
        ['id' => 'America/Indiana/Vevay', 'text' => '(UTC-05:00) Vevay'],
        ['id' => 'America/Indiana/Vincennes', 'text' => '(UTC-05:00) Vincennes'],
        ['id' => 'America/Indiana/Winamac', 'text' => '(UTC-05:00) Winamac'],
        ['id' => 'America/Caracas', 'text' => '(UTC-04:30) Caracas'],
        ['id' => 'America/Anguilla', 'text' => '(UTC-04:00) Anguilla'],
        ['id' => 'America/Antigua', 'text' => '(UTC-04:00) Antigua'],
        ['id' => 'America/Aruba', 'text' => '(UTC-04:00) Aruba'],
        ['id' => 'America/Asuncion', 'text' => '(UTC-04:00) Asuncion'],
        ['id' => 'America/Barbados', 'text' => '(UTC-04:00) Barbados'],
        ['id' => 'Atlantic/Bermuda', 'text' => '(UTC-04:00) Bermuda'],
        ['id' => 'America/Blanc-Sablon', 'text' => '(UTC-04:00) Blanc-Sablon'],
        ['id' => 'America/Boa_Vista', 'text' => '(UTC-04:00) Boa Vista'],
        ['id' => 'America/Campo_Grande', 'text' => '(UTC-04:00) Campo Grande'],
        ['id' => 'America/Cuiaba', 'text' => '(UTC-04:00) Cuiaba'],
        ['id' => 'America/Curacao', 'text' => '(UTC-04:00) Curacao'],
        ['id' => 'America/Dominica', 'text' => '(UTC-04:00) Dominica'],
        ['id' => 'America/Eirunepe', 'text' => '(UTC-04:00) Eirunepe'],
        ['id' => 'America/Glace_Bay', 'text' => '(UTC-04:00) Glace Bay'],
        ['id' => 'America/Goose_Bay', 'text' => '(UTC-04:00) Goose Bay'],
        ['id' => 'America/Grenada', 'text' => '(UTC-04:00) Grenada'],
        ['id' => 'America/Guadeloupe', 'text' => '(UTC-04:00) Guadeloupe'],
        ['id' => 'America/Guyana', 'text' => '(UTC-04:00) Guyana'],
        ['id' => 'America/Halifax', 'text' => '(UTC-04:00) Halifax'],
        ['id' => 'America/Kralendijk', 'text' => '(UTC-04:00) Kralendijk'],
        ['id' => 'America/La_Paz', 'text' => '(UTC-04:00) La Paz'],
        ['id' => 'America/Lower_Princes', 'text' => '(UTC-04:00) Lower Princes'],
        ['id' => 'America/Manaus', 'text' => '(UTC-04:00) Manaus'],
        ['id' => 'America/Marigot', 'text' => '(UTC-04:00) Marigot'],
        ['id' => 'America/Martinique', 'text' => '(UTC-04:00) Martinique'],
        ['id' => 'America/Moncton', 'text' => '(UTC-04:00) Moncton'],
        ['id' => 'America/Montserrat', 'text' => '(UTC-04:00) Montserrat'],
        ['id' => 'Antarctica/Palmer', 'text' => '(UTC-04:00) Palmer'],
        ['id' => 'America/Port_of_Spain', 'text' => '(UTC-04:00) Port of Spain'],
        ['id' => 'America/Porto_Velho', 'text' => '(UTC-04:00) Porto Velho'],
        ['id' => 'America/Puerto_Rico', 'text' => '(UTC-04:00) Puerto Rico'],
        ['id' => 'America/Rio_Branco', 'text' => '(UTC-04:00) Rio Branco'],
        ['id' => 'America/Santiago', 'text' => '(UTC-04:00) Santiago'],
        ['id' => 'America/Santo_Domingo', 'text' => '(UTC-04:00) Santo Domingo'],
        ['id' => 'America/St_Barthelemy', 'text' => '(UTC-04:00) St. Barthelemy'],
        ['id' => 'America/St_Kitts', 'text' => '(UTC-04:00) St. Kitts'],
        ['id' => 'America/St_Lucia', 'text' => '(UTC-04:00) St. Lucia'],
        ['id' => 'America/St_Thomas', 'text' => '(UTC-04:00) St. Thomas'],
        ['id' => 'America/St_Vincent', 'text' => '(UTC-04:00) St. Vincent'],
        ['id' => 'America/Thule', 'text' => '(UTC-04:00) Thule'],
        ['id' => 'America/Tortola', 'text' => '(UTC-04:00) Tortola'],
        ['id' => 'America/St_Johns', 'text' => '(UTC-03:30) St. Johns'],
        ['id' => 'America/Araguaina', 'text' => '(UTC-03:00) Araguaina'],
        ['id' => 'America/Bahia', 'text' => '(UTC-03:00) Bahia'],
        ['id' => 'America/Belem', 'text' => '(UTC-03:00) Belem'],
        ['id' => 'America/Argentina/Buenos_Aires', 'text' => '(UTC-03:00) Buenos Aires'],
        ['id' => 'America/Argentina/Catamarca', 'text' => '(UTC-03:00) Catamarca'],
        ['id' => 'America/Cayenne', 'text' => '(UTC-03:00) Cayenne'],
        ['id' => 'America/Argentina/Cordoba', 'text' => '(UTC-03:00) Cordoba'],
        ['id' => 'America/Fortaleza', 'text' => '(UTC-03:00) Fortaleza'],
        ['id' => 'America/Godthab', 'text' => '(UTC-03:00) Godthab'],
        ['id' => 'America/Argentina/Jujuy', 'text' => '(UTC-03:00) Jujuy'],
        ['id' => 'America/Argentina/La_Rioja', 'text' => '(UTC-03:00) La Rioja'],
        ['id' => 'America/Maceio', 'text' => '(UTC-03:00) Maceio'],
        ['id' => 'America/Argentina/Mendoza', 'text' => '(UTC-03:00) Mendoza'],
        ['id' => 'America/Miquelon', 'text' => '(UTC-03:00) Miquelon'],
        ['id' => 'America/Montevideo', 'text' => '(UTC-03:00) Montevideo'],
        ['id' => 'America/Paramaribo', 'text' => '(UTC-03:00) Paramaribo'],
        ['id' => 'America/Recife', 'text' => '(UTC-03:00) Recife'],
        ['id' => 'America/Argentina/Rio_Gallegos', 'text' => '(UTC-03:00) Rio Gallegos'],
        ['id' => 'Antarctica/Rothera', 'text' => '(UTC-03:00) Rothera'],
        ['id' => 'America/Argentina/Salta', 'text' => '(UTC-03:00) Salta'],
        ['id' => 'America/Argentina/San_Juan', 'text' => '(UTC-03:00) San Juan'],
        ['id' => 'America/Argentina/San_Luis', 'text' => '(UTC-03:00) San Luis'],
        ['id' => 'America/Santarem', 'text' => '(UTC-03:00) Santarem'],
        ['id' => 'America/Sao_Paulo', 'text' => '(UTC-03:00) Sao Paulo'],
        ['id' => 'Atlantic/Stanley', 'text' => '(UTC-03:00) Stanley'],
        ['id' => 'America/Argentina/Tucuman', 'text' => '(UTC-03:00) Tucuman'],
        ['id' => 'America/Argentina/Ushuaia', 'text' => '(UTC-03:00) Ushuaia'],
        ['id' => 'America/Noronha', 'text' => '(UTC-02:00) Noronha'],
        ['id' => 'Atlantic/South_Georgia', 'text' => '(UTC-02:00) South Georgia'],
        ['id' => 'Atlantic/Azores', 'text' => '(UTC-01:00) Azores'],
        ['id' => 'Atlantic/Cape_Verde', 'text' => '(UTC-01:00) Cape Verde'],
        ['id' => 'America/Scoresbysund', 'text' => '(UTC-01:00) Scoresbysund'],
        ['id' => 'Africa/Abidjan', 'text' => '(UTC+00:00) Abidjan'],
        ['id' => 'Africa/Accra', 'text' => '(UTC+00:00) Accra'],
        ['id' => 'Africa/Bamako', 'text' => '(UTC+00:00) Bamako'],
        ['id' => 'Africa/Banjul', 'text' => '(UTC+00:00) Banjul'],
        ['id' => 'Africa/Bissau', 'text' => '(UTC+00:00) Bissau'],
        ['id' => 'Atlantic/Canary', 'text' => '(UTC+00:00) Canary'],
        ['id' => 'Africa/Casablanca', 'text' => '(UTC+00:00) Casablanca'],
        ['id' => 'Africa/Conakry', 'text' => '(UTC+00:00) Conakry'],
        ['id' => 'Africa/Dakar', 'text' => '(UTC+00:00) Dakar'],
        ['id' => 'America/Danmarkshavn', 'text' => '(UTC+00:00) Danmarkshavn'],
        ['id' => 'Europe/Dublin', 'text' => '(UTC+00:00) Dublin'],
        ['id' => 'Africa/El_Aaiun', 'text' => '(UTC+00:00) El Aaiun'],
        ['id' => 'Atlantic/Faroe', 'text' => '(UTC+00:00) Faroe'],
        ['id' => 'Africa/Freetown', 'text' => '(UTC+00:00) Freetown'],
        ['id' => 'Europe/Guernsey', 'text' => '(UTC+00:00) Guernsey'],
        ['id' => 'Europe/Isle_of_Man', 'text' => '(UTC+00:00) Isle of Man'],
        ['id' => 'Europe/Jersey', 'text' => '(UTC+00:00) Jersey'],
        ['id' => 'Europe/Lisbon', 'text' => '(UTC+00:00) Lisbon'],
        ['id' => 'Africa/Lome', 'text' => '(UTC+00:00) Lome'],
        ['id' => 'Europe/London', 'text' => '(UTC+00:00) London'],
        ['id' => 'Atlantic/Madeira', 'text' => '(UTC+00:00) Madeira'],
        ['id' => 'Africa/Monrovia', 'text' => '(UTC+00:00) Monrovia'],
        ['id' => 'Africa/Nouakchott', 'text' => '(UTC+00:00) Nouakchott'],
        ['id' => 'Africa/Ouagadougou', 'text' => '(UTC+00:00) Ouagadougou'],
        ['id' => 'Atlantic/Reykjavik', 'text' => '(UTC+00:00) Reykjavik'],
        ['id' => 'Africa/Sao_Tome', 'text' => '(UTC+00:00) Sao Tome'],
        ['id' => 'Atlantic/St_Helena', 'text' => '(UTC+00:00) St. Helena'],
        ['id' => 'UTC', 'text' => '(UTC+00:00) UTC'],
        ['id' => 'Africa/Algiers', 'text' => '(UTC+01:00) Algiers'],
        ['id' => 'Europe/Amsterdam', 'text' => '(UTC+01:00) Amsterdam'],
        ['id' => 'Europe/Andorra', 'text' => '(UTC+01:00) Andorra'],
        ['id' => 'Africa/Bangui', 'text' => '(UTC+01:00) Bangui'],
        ['id' => 'Europe/Belgrade', 'text' => '(UTC+01:00) Belgrade'],
        ['id' => 'Europe/Berlin', 'text' => '(UTC+01:00) Berlin'],
        ['id' => 'Europe/Bratislava', 'text' => '(UTC+01:00) Bratislava'],
        ['id' => 'Africa/Brazzaville', 'text' => '(UTC+01:00) Brazzaville'],
        ['id' => 'Europe/Brussels', 'text' => '(UTC+01:00) Brussels'],
        ['id' => 'Europe/Budapest', 'text' => '(UTC+01:00) Budapest'],
        ['id' => 'Europe/Busingen', 'text' => '(UTC+01:00) Busingen'],
        ['id' => 'Africa/Ceuta', 'text' => '(UTC+01:00) Ceuta'],
        ['id' => 'Europe/Copenhagen', 'text' => '(UTC+01:00) Copenhagen'],
        ['id' => 'Africa/Douala', 'text' => '(UTC+01:00) Douala'],
        ['id' => 'Europe/Gibraltar', 'text' => '(UTC+01:00) Gibraltar'],
        ['id' => 'Africa/Kinshasa', 'text' => '(UTC+01:00) Kinshasa'],
        ['id' => 'Africa/Lagos', 'text' => '(UTC+01:00) Lagos'],
        ['id' => 'Africa/Libreville', 'text' => '(UTC+01:00) Libreville'],
        ['id' => 'Europe/Ljubljana', 'text' => '(UTC+01:00) Ljubljana'],
        ['id' => 'Arctic/Longyearbyen', 'text' => '(UTC+01:00) Longyearbyen'],
        ['id' => 'Africa/Luanda', 'text' => '(UTC+01:00) Luanda'],
        ['id' => 'Europe/Luxembourg', 'text' => '(UTC+01:00) Luxembourg'],
        ['id' => 'Europe/Madrid', 'text' => '(UTC+01:00) Madrid'],
        ['id' => 'Africa/Malabo', 'text' => '(UTC+01:00) Malabo'],
        ['id' => 'Europe/Malta', 'text' => '(UTC+01:00) Malta'],
        ['id' => 'Europe/Monaco', 'text' => '(UTC+01:00) Monaco'],
        ['id' => 'Africa/Ndjamena', 'text' => '(UTC+01:00) Ndjamena'],
        ['id' => 'Africa/Niamey', 'text' => '(UTC+01:00) Niamey'],
        ['id' => 'Europe/Oslo', 'text' => '(UTC+01:00) Oslo'],
        ['id' => 'Europe/Paris', 'text' => '(UTC+01:00) Paris'],
        ['id' => 'Europe/Podgorica', 'text' => '(UTC+01:00) Podgorica'],
        ['id' => 'Africa/Porto-Novo', 'text' => '(UTC+01:00) Porto-Novo'],
        ['id' => 'Europe/Prague', 'text' => '(UTC+01:00) Prague'],
        ['id' => 'Europe/Rome', 'text' => '(UTC+01:00) Rome'],
        ['id' => 'Europe/San_Marino', 'text' => '(UTC+01:00) San Marino'],
        ['id' => 'Europe/Sarajevo', 'text' => '(UTC+01:00) Sarajevo'],
        ['id' => 'Europe/Skopje', 'text' => '(UTC+01:00) Skopje'],
        ['id' => 'Europe/Stockholm', 'text' => '(UTC+01:00) Stockholm'],
        ['id' => 'Europe/Tirane', 'text' => '(UTC+01:00) Tirane'],
        ['id' => 'Africa/Tripoli', 'text' => '(UTC+01:00) Tripoli'],
        ['id' => 'Africa/Tunis', 'text' => '(UTC+01:00) Tunis'],
        ['id' => 'Europe/Vaduz', 'text' => '(UTC+01:00) Vaduz'],
        ['id' => 'Europe/Vatican', 'text' => '(UTC+01:00) Vatican'],
        ['id' => 'Europe/Vienna', 'text' => '(UTC+01:00) Vienna'],
        ['id' => 'Europe/Warsaw', 'text' => '(UTC+01:00) Warsaw'],
        ['id' => 'Africa/Windhoek', 'text' => '(UTC+01:00) Windhoek'],
        ['id' => 'Europe/Zagreb', 'text' => '(UTC+01:00) Zagreb'],
        ['id' => 'Europe/Zurich', 'text' => '(UTC+01:00) Zurich'],
        ['id' => 'Europe/Athens', 'text' => '(UTC+02:00) Athens'],
        ['id' => 'Asia/Beirut', 'text' => '(UTC+02:00) Beirut'],
        ['id' => 'Africa/Blantyre', 'text' => '(UTC+02:00) Blantyre'],
        ['id' => 'Europe/Bucharest', 'text' => '(UTC+02:00) Bucharest'],
        ['id' => 'Africa/Bujumbura', 'text' => '(UTC+02:00) Bujumbura'],
        ['id' => 'Africa/Cairo', 'text' => '(UTC+02:00) Cairo'],
        ['id' => 'Europe/Chisinau', 'text' => '(UTC+02:00) Chisinau'],
        ['id' => 'Asia/Damascus', 'text' => '(UTC+02:00) Damascus'],
        ['id' => 'Africa/Gaborone', 'text' => '(UTC+02:00) Gaborone'],
        ['id' => 'Asia/Gaza', 'text' => '(UTC+02:00) Gaza'],
        ['id' => 'Africa/Harare', 'text' => '(UTC+02:00) Harare'],
        ['id' => 'Asia/Hebron', 'text' => '(UTC+02:00) Hebron'],
        ['id' => 'Europe/Helsinki', 'text' => '(UTC+02:00) Helsinki'],
        ['id' => 'Europe/Istanbul', 'text' => '(UTC+02:00) Istanbul'],
        ['id' => 'Asia/Jerusalem', 'text' => '(UTC+02:00) Jerusalem'],
        ['id' => 'Africa/Johannesburg', 'text' => '(UTC+02:00) Johannesburg'],
        ['id' => 'Europe/Kiev', 'text' => '(UTC+02:00) Kiev'],
        ['id' => 'Africa/Kigali', 'text' => '(UTC+02:00) Kigali'],
        ['id' => 'Africa/Lubumbashi', 'text' => '(UTC+02:00) Lubumbashi'],
        ['id' => 'Africa/Lusaka', 'text' => '(UTC+02:00) Lusaka'],
        ['id' => 'Africa/Maputo', 'text' => '(UTC+02:00) Maputo'],
        ['id' => 'Europe/Mariehamn', 'text' => '(UTC+02:00) Mariehamn'],
        ['id' => 'Africa/Maseru', 'text' => '(UTC+02:00) Maseru'],
        ['id' => 'Africa/Mbabane', 'text' => '(UTC+02:00) Mbabane'],
        ['id' => 'Asia/Nicosia', 'text' => '(UTC+02:00) Nicosia'],
        ['id' => 'Europe/Riga', 'text' => '(UTC+02:00) Riga'],
        ['id' => 'Europe/Simferopol', 'text' => '(UTC+02:00) Simferopol'],
        ['id' => 'Europe/Sofia', 'text' => '(UTC+02:00) Sofia'],
        ['id' => 'Europe/Tallinn', 'text' => '(UTC+02:00) Tallinn'],
        ['id' => 'Europe/Uzhgorod', 'text' => '(UTC+02:00) Uzhgorod'],
        ['id' => 'Europe/Vilnius', 'text' => '(UTC+02:00) Vilnius'],
        ['id' => 'Europe/Zaporozhye', 'text' => '(UTC+02:00) Zaporozhye'],
        ['id' => 'Africa/Addis_Ababa', 'text' => '(UTC+03:00) Addis Ababa'],
        ['id' => 'Asia/Aden', 'text' => '(UTC+03:00) Aden'],
        ['id' => 'Asia/Amman', 'text' => '(UTC+03:00) Amman'],
        ['id' => 'Indian/Antananarivo', 'text' => '(UTC+03:00) Antananarivo'],
        ['id' => 'Africa/Asmara', 'text' => '(UTC+03:00) Asmara'],
        ['id' => 'Asia/Baghdad', 'text' => '(UTC+03:00) Baghdad'],
        ['id' => 'Asia/Bahrain', 'text' => '(UTC+03:00) Bahrain'],
        ['id' => 'Indian/Comoro', 'text' => '(UTC+03:00) Comoro'],
        ['id' => 'Africa/Dar_es_Salaam', 'text' => '(UTC+03:00) Dar es Salaam'],
        ['id' => 'Africa/Djibouti', 'text' => '(UTC+03:00) Djibouti'],
        ['id' => 'Africa/Juba', 'text' => '(UTC+03:00) Juba'],
        ['id' => 'Europe/Kaliningrad', 'text' => '(UTC+03:00) Kaliningrad'],
        ['id' => 'Africa/Kampala', 'text' => '(UTC+03:00) Kampala'],
        ['id' => 'Africa/Khartoum', 'text' => '(UTC+03:00) Khartoum'],
        ['id' => 'Asia/Kuwait', 'text' => '(UTC+03:00) Kuwait'],
        ['id' => 'Indian/Mayotte', 'text' => '(UTC+03:00) Mayotte'],
        ['id' => 'Europe/Minsk', 'text' => '(UTC+03:00) Minsk'],
        ['id' => 'Africa/Mogadishu', 'text' => '(UTC+03:00) Mogadishu'],
        ['id' => 'Africa/Nairobi', 'text' => '(UTC+03:00) Nairobi'],
        ['id' => 'Asia/Qatar', 'text' => '(UTC+03:00) Qatar'],
        ['id' => 'Asia/Riyadh', 'text' => '(UTC+03:00) Riyadh'],
        ['id' => 'Antarctica/Syowa', 'text' => '(UTC+03:00) Syowa'],
        ['id' => 'Asia/Tehran', 'text' => '(UTC+03:30) Tehran'],
        ['id' => 'Asia/Baku', 'text' => '(UTC+04:00) Baku'],
        ['id' => 'Asia/Dubai', 'text' => '(UTC+04:00) Dubai'],
        ['id' => 'Indian/Mahe', 'text' => '(UTC+04:00) Mahe'],
        ['id' => 'Indian/Mauritius', 'text' => '(UTC+04:00) Mauritius'],
        ['id' => 'Europe/Moscow', 'text' => '(UTC+04:00) Moscow'],
        ['id' => 'Asia/Muscat', 'text' => '(UTC+04:00) Muscat'],
        ['id' => 'Indian/Reunion', 'text' => '(UTC+04:00) Reunion'],
        ['id' => 'Europe/Samara', 'text' => '(UTC+04:00) Samara'],
        ['id' => 'Asia/Tbilisi', 'text' => '(UTC+04:00) Tbilisi'],
        ['id' => 'Europe/Volgograd', 'text' => '(UTC+04:00) Volgograd'],
        ['id' => 'Asia/Yerevan', 'text' => '(UTC+04:00) Yerevan'],
        ['id' => 'Asia/Kabul', 'text' => '(UTC+04:30) Kabul'],
        ['id' => 'Asia/Aqtau', 'text' => '(UTC+05:00) Aqtau'],
        ['id' => 'Asia/Aqtobe', 'text' => '(UTC+05:00) Aqtobe'],
        ['id' => 'Asia/Ashgabat', 'text' => '(UTC+05:00) Ashgabat'],
        ['id' => 'Asia/Dushanbe', 'text' => '(UTC+05:00) Dushanbe'],
        ['id' => 'Asia/Karachi', 'text' => '(UTC+05:00) Karachi'],
        ['id' => 'Indian/Kerguelen', 'text' => '(UTC+05:00) Kerguelen'],
        ['id' => 'Indian/Maldives', 'text' => '(UTC+05:00) Maldives'],
        ['id' => 'Antarctica/Mawson', 'text' => '(UTC+05:00) Mawson'],
        ['id' => 'Asia/Oral', 'text' => '(UTC+05:00) Oral'],
        ['id' => 'Asia/Samarkand', 'text' => '(UTC+05:00) Samarkand'],
        ['id' => 'Asia/Tashkent', 'text' => '(UTC+05:00) Tashkent'],
        ['id' => 'Asia/Colombo', 'text' => '(UTC+05:30) Colombo'],
        ['id' => 'Asia/Kolkata', 'text' => '(UTC+05:30) Kolkata'],
        ['id' => 'Asia/Kathmandu', 'text' => '(UTC+05:45) Kathmandu'],
        ['id' => 'Asia/Almaty', 'text' => '(UTC+06:00) Almaty'],
        ['id' => 'Asia/Bishkek', 'text' => '(UTC+06:00) Bishkek'],
        ['id' => 'Indian/Chagos', 'text' => '(UTC+06:00) Chagos'],
        ['id' => 'Asia/Dhaka', 'text' => '(UTC+06:00) Dhaka'],
        ['id' => 'Asia/Qyzylorda', 'text' => '(UTC+06:00) Qyzylorda'],
        ['id' => 'Asia/Thimphu', 'text' => '(UTC+06:00) Thimphu'],
        ['id' => 'Antarctica/Vostok', 'text' => '(UTC+06:00) Vostok'],
        ['id' => 'Asia/Yekaterinburg', 'text' => '(UTC+06:00) Yekaterinburg'],
        ['id' => 'Indian/Cocos', 'text' => '(UTC+06:30) Cocos'],
        ['id' => 'Asia/Rangoon', 'text' => '(UTC+06:30) Rangoon'],
        ['id' => 'Asia/Bangkok', 'text' => '(UTC+07:00) Bangkok'],
        ['id' => 'Indian/Christmas', 'text' => '(UTC+07:00) Christmas'],
        ['id' => 'Antarctica/Davis', 'text' => '(UTC+07:00) Davis'],
        ['id' => 'Asia/Ho_Chi_Minh', 'text' => '(UTC+07:00) Ho Chi Minh'],
        ['id' => 'Asia/Hovd', 'text' => '(UTC+07:00) Hovd'],
        ['id' => 'Asia/Jakarta', 'text' => '(UTC+07:00) Jakarta'],
        ['id' => 'Asia/Novokuznetsk', 'text' => '(UTC+07:00) Novokuznetsk'],
        ['id' => 'Asia/Novosibirsk', 'text' => '(UTC+07:00) Novosibirsk'],
        ['id' => 'Asia/Omsk', 'text' => '(UTC+07:00) Omsk'],
        ['id' => 'Asia/Phnom_Penh', 'text' => '(UTC+07:00) Phnom Penh'],
        ['id' => 'Asia/Pontianak', 'text' => '(UTC+07:00) Pontianak'],
        ['id' => 'Asia/Vientiane', 'text' => '(UTC+07:00) Vientiane'],
        ['id' => 'Asia/Brunei', 'text' => '(UTC+08:00) Brunei'],
        ['id' => 'Antarctica/Casey', 'text' => '(UTC+08:00) Casey'],
        ['id' => 'Asia/Choibalsan', 'text' => '(UTC+08:00) Choibalsan'],
        ['id' => 'Asia/Chongqing', 'text' => '(UTC+08:00) Chongqing'],
        ['id' => 'Asia/Harbin', 'text' => '(UTC+08:00) Harbin'],
        ['id' => 'Asia/Hong_Kong', 'text' => '(UTC+08:00) Hong Kong'],
        ['id' => 'Asia/Kashgar', 'text' => '(UTC+08:00) Kashgar'],
        ['id' => 'Asia/Krasnoyarsk', 'text' => '(UTC+08:00) Krasnoyarsk'],
        ['id' => 'Asia/Kuala_Lumpur', 'text' => '(UTC+08:00) Kuala Lumpur'],
        ['id' => 'Asia/Kuching', 'text' => '(UTC+08:00) Kuching'],
        ['id' => 'Asia/Macau', 'text' => '(UTC+08:00) Macau'],
        ['id' => 'Asia/Makassar', 'text' => '(UTC+08:00) Makassar'],
        ['id' => 'Asia/Manila', 'text' => '(UTC+08:00) Manila'],
        ['id' => 'Australia/Perth', 'text' => '(UTC+08:00) Perth'],
        ['id' => 'Asia/Shanghai', 'text' => '(UTC+08:00) Shanghai'],
        ['id' => 'Asia/Singapore', 'text' => '(UTC+08:00) Singapore'],
        ['id' => 'Asia/Taipei', 'text' => '(UTC+08:00) Taipei'],
        ['id' => 'Asia/Ulaanbaatar', 'text' => '(UTC+08:00) Ulaanbaatar'],
        ['id' => 'Asia/Urumqi', 'text' => '(UTC+08:00) Urumqi'],
        ['id' => 'Australia/Eucla', 'text' => '(UTC+08:45) Eucla'],
        ['id' => 'Asia/Dili', 'text' => '(UTC+09:00) Dili'],
        ['id' => 'Asia/Irkutsk', 'text' => '(UTC+09:00) Irkutsk'],
        ['id' => 'Asia/Jayapura', 'text' => '(UTC+09:00) Jayapura'],
        ['id' => 'Pacific/Palau', 'text' => '(UTC+09:00) Palau'],
        ['id' => 'Asia/Pyongyang', 'text' => '(UTC+09:00) Pyongyang'],
        ['id' => 'Asia/Seoul', 'text' => '(UTC+09:00) Seoul'],
        ['id' => 'Asia/Tokyo', 'text' => '(UTC+09:00) Tokyo'],
        ['id' => 'Australia/Adelaide', 'text' => '(UTC+09:30) Adelaide'],
        ['id' => 'Australia/Broken_Hill', 'text' => '(UTC+09:30) Broken Hill'],
        ['id' => 'Australia/Darwin', 'text' => '(UTC+09:30) Darwin'],
        ['id' => 'Australia/Brisbane', 'text' => '(UTC+10:00) Brisbane'],
        ['id' => 'Pacific/Chuuk', 'text' => '(UTC+10:00) Chuuk'],
        ['id' => 'Australia/Currie', 'text' => '(UTC+10:00) Currie'],
        ['id' => 'Antarctica/DumontDUrville', 'text' => '(UTC+10:00) DumontDUrville'],
        ['id' => 'Pacific/Guam', 'text' => '(UTC+10:00) Guam'],
        ['id' => 'Australia/Hobart', 'text' => '(UTC+10:00) Hobart'],
        ['id' => 'Asia/Khandyga', 'text' => '(UTC+10:00) Khandyga'],
        ['id' => 'Australia/Lindeman', 'text' => '(UTC+10:00) Lindeman'],
        ['id' => 'Australia/Melbourne', 'text' => '(UTC+10:00) Melbourne'],
        ['id' => 'Pacific/Port_Moresby', 'text' => '(UTC+10:00) Port Moresby'],
        ['id' => 'Pacific/Saipan', 'text' => '(UTC+10:00) Saipan'],
        ['id' => 'Australia/Sydney', 'text' => '(UTC+10:00) Sydney'],
        ['id' => 'Asia/Yakutsk', 'text' => '(UTC+10:00) Yakutsk'],
        ['id' => 'Australia/Lord_Howe', 'text' => '(UTC+10:30) Lord Howe'],
        ['id' => 'Pacific/Efate', 'text' => '(UTC+11:00) Efate'],
        ['id' => 'Pacific/Guadalcanal', 'text' => '(UTC+11:00) Guadalcanal'],
        ['id' => 'Pacific/Kosrae', 'text' => '(UTC+11:00) Kosrae'],
        ['id' => 'Antarctica/Macquarie', 'text' => '(UTC+11:00) Macquarie'],
        ['id' => 'Pacific/Noumea', 'text' => '(UTC+11:00) Noumea'],
        ['id' => 'Pacific/Pohnpei', 'text' => '(UTC+11:00) Pohnpei'],
        ['id' => 'Asia/Sakhalin', 'text' => '(UTC+11:00) Sakhalin'],
        ['id' => 'Asia/Ust-Nera', 'text' => '(UTC+11:00) Ust-Nera'],
        ['id' => 'Asia/Vladivostok', 'text' => '(UTC+11:00) Vladivostok'],
        ['id' => 'Pacific/Norfolk', 'text' => '(UTC+11:30) Norfolk'],
        ['id' => 'Asia/Anadyr', 'text' => '(UTC+12:00) Anadyr'],
        ['id' => 'Pacific/Auckland', 'text' => '(UTC+12:00) Auckland'],
        ['id' => 'Pacific/Fiji', 'text' => '(UTC+12:00) Fiji'],
        ['id' => 'Pacific/Funafuti', 'text' => '(UTC+12:00) Funafuti'],
        ['id' => 'Asia/Kamchatka', 'text' => '(UTC+12:00) Kamchatka'],
        ['id' => 'Pacific/Kwajalein', 'text' => '(UTC+12:00) Kwajalein'],
        ['id' => 'Asia/Magadan', 'text' => '(UTC+12:00) Magadan'],
        ['id' => 'Pacific/Majuro', 'text' => '(UTC+12:00) Majuro'],
        ['id' => 'Antarctica/McMurdo', 'text' => '(UTC+12:00) McMurdo'],
        ['id' => 'Pacific/Nauru', 'text' => '(UTC+12:00) Nauru'],
        ['id' => 'Antarctica/South_Pole', 'text' => '(UTC+12:00) South Pole'],
        ['id' => 'Pacific/Tarawa', 'text' => '(UTC+12:00) Tarawa'],
        ['id' => 'Pacific/Wake', 'text' => '(UTC+12:00) Wake'],
        ['id' => 'Pacific/Wallis', 'text' => '(UTC+12:00) Wallis'],
        ['id' => 'Pacific/Chatham', 'text' => '(UTC+12:45) Chatham'],
        ['id' => 'Pacific/Apia', 'text' => '(UTC+13:00) Apia'],
        ['id' => 'Pacific/Enderbury', 'text' => '(UTC+13:00) Enderbury'],
        ['id' => 'Pacific/Fakaofo', 'text' => '(UTC+13:00) Fakaofo'],
        ['id' => 'Pacific/Tongatapu', 'text' => '(UTC+13:00) Tongatapu'],
        ['id' => 'Pacific/Kiritimati', 'text' => '(UTC+14:00) Kiritimati'],
    ];

    public static function getSelect2Array()
    {
        $timeZones = collect();
        foreach (static::$timeZones as $timezone) {
            $timeZones->push([
                'id' => $timezone['id'],
                'text' => $timezone['text'],
            ]); 
        }
        return $timeZones;
    }
}
