@if($dueInvoices->count() > 0)
    <table class="table table-striped border-bottom mb-0">
        <tbody>
            @foreach ($dueInvoices as $invoice)
                <tr>
                    <td>
                        <div>
                            <a href="{{ route('invoices.details', ['invoice' => $invoice->id, 'company_uid' => $currentCompany->uid]) }}" class="text-15pt d-flex align-items-center">
                                <strong>{{ $invoice->invoice_number }}</strong>
                            </a>
                        </div>
                    </td>
                    <td class="text-center">
                        <a href="{{ route('customers.details', ['customer' => $invoice->customer->id, 'company_uid' => $currentCompany->uid]) }}">
                            {{ $invoice->customer->display_name }}
                        </a>
                    </td>
                    <td class="text-center">
                        @if($invoice->status == 'DRAFT')
                            <div class="badge badge-dark">
                                {{ __('messages.' . $invoice->status) }}
                            </div>
                        @elseif($invoice->status == 'SENT')
                            <div class="badge badge-info">
                                {{ __('messages.' . $invoice->status) }}
                            </div>
                        @elseif($invoice->status == 'VIEWED')
                            <div class="badge badge-primary">
                                {{ __('messages.' . $invoice->status) }}
                            </div>
                        @elseif($invoice->status == 'OVERDUE')
                            <div class="badge badge-danger">
                                {{ __('messages.' . $invoice->status) }}
                            </div>
                        @elseif($invoice->status == 'COMPLETED')
                            <div class="badge badge-success">
                                {{ __('messages.' . $invoice->status) }}
                            </div>
                        @endif
                    </td>
                    <td class="text-right">
                        {!! money($invoice->due_amount, $invoice->currency_code) !!}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@else
    <div class="row justify-content-center card-body pb-0 pt-5">
        <i class="material-icons fs-64px">receipt</i>
    </div>
    <div class="row justify-content-center card-body pb-5">
        <p class="h4">{{ __('messages.no_due_invoices') }}</p>
    </div>
@endif
