--
-- PostgreSQL database dump
--

-- Dumped from database version 14.1 (Debian 14.1-1.pgdg110+1)
-- Dumped by pg_dump version 14.1 (Debian 14.1-1.pgdg110+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

ALTER TABLE ONLY public.userrecovery DROP CONSTRAINT userrecovery_user_id_fkey;
ALTER TABLE ONLY public.useremailverification DROP CONSTRAINT useremailverification_user_id_fkey;
ALTER TABLE ONLY public.hashtagpost DROP CONSTRAINT hashtagpost_post_id_fkey;
ALTER TABLE ONLY public.hashtagpost DROP CONSTRAINT hashtagpost_hashtag_id_fkey;
DROP INDEX public.index_foreignkey_userrecovery_user;
DROP INDEX public.index_foreignkey_userfollow_followed_user;
DROP INDEX public.index_foreignkey_userfollow_followed_by_user;
DROP INDEX public.index_foreignkey_useremailverification_user;
DROP INDEX public.index_foreignkey_userblock_blocked_user;
DROP INDEX public.index_foreignkey_userblock_blocked_by_user;
DROP INDEX public.index_foreignkey_postusertag_tagged_user;
DROP INDEX public.index_foreignkey_postusertag_tagged_in_post;
DROP INDEX public.index_foreignkey_postusertag_post_owner_user;
DROP INDEX public.index_foreignkey_postsave_saved_to_collection;
DROP INDEX public.index_foreignkey_postsave_saved_post;
DROP INDEX public.index_foreignkey_postsave_saved_by_user;
DROP INDEX public.index_foreignkey_postlike_liked_post;
DROP INDEX public.index_foreignkey_postlike_liked_by_user;
DROP INDEX public.index_foreignkey_postcommentlike_parent_post;
DROP INDEX public.index_foreignkey_postcommentlike_liked_postcomment;
DROP INDEX public.index_foreignkey_postcommentlike_liked_by_user;
DROP INDEX public.index_foreignkey_postcomment_reply_to_postcomment;
DROP INDEX public.index_foreignkey_postcomment_parent_post;
DROP INDEX public.index_foreignkey_postcomment_owner_user;
DROP INDEX public.index_foreignkey_post_owner_user;
DROP INDEX public.index_foreignkey_notification_to_user;
DROP INDEX public.index_foreignkey_notification_target_content;
DROP INDEX public.index_foreignkey_hashtagpost_post_owner_user;
DROP INDEX public.index_foreignkey_hashtagpost_post;
DROP INDEX public.index_foreignkey_hashtagpost_hashtag;
DROP INDEX public.index_foreignkey_hashtagfollow_followed_hashtag;
DROP INDEX public.index_foreignkey_hashtagfollow_followed_by_user;
DROP INDEX public.index_foreignkey_collection_owner_user;
ALTER TABLE ONLY public.userrecovery DROP CONSTRAINT userrecovery_pkey;
ALTER TABLE ONLY public.userfollow DROP CONSTRAINT userfollow_pkey;
ALTER TABLE ONLY public.useremailverification DROP CONSTRAINT useremailverification_pkey;
ALTER TABLE ONLY public.userblock DROP CONSTRAINT userblock_pkey;
ALTER TABLE ONLY public."user" DROP CONSTRAINT user_pkey;
ALTER TABLE ONLY public.setting DROP CONSTRAINT setting_pkey;
ALTER TABLE ONLY public.postusertag DROP CONSTRAINT postusertag_pkey;
ALTER TABLE ONLY public.postsave DROP CONSTRAINT postsave_pkey;
ALTER TABLE ONLY public.postlike DROP CONSTRAINT postlike_pkey;
ALTER TABLE ONLY public.postcommentlike DROP CONSTRAINT postcommentlike_pkey;
ALTER TABLE ONLY public.postcomment DROP CONSTRAINT postcomment_pkey;
ALTER TABLE ONLY public.post DROP CONSTRAINT post_pkey;
ALTER TABLE ONLY public.notification DROP CONSTRAINT notification_pkey;
ALTER TABLE ONLY public.hashtagpost DROP CONSTRAINT hashtagpost_pkey;
ALTER TABLE ONLY public.hashtagfollow DROP CONSTRAINT hashtagfollow_pkey;
ALTER TABLE ONLY public.hashtag DROP CONSTRAINT hashtag_pkey;
ALTER TABLE ONLY public.collection DROP CONSTRAINT collection_pkey;
ALTER TABLE ONLY public.admin DROP CONSTRAINT admin_pkey;
ALTER TABLE public.userrecovery ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.userfollow ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.useremailverification ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.userblock ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public."user" ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.setting ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.postusertag ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.postsave ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.postlike ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.postcommentlike ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.postcomment ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.post ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.notification ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.hashtagpost ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.hashtagfollow ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.hashtag ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.collection ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.admin ALTER COLUMN id DROP DEFAULT;
DROP SEQUENCE public.userrecovery_id_seq;
DROP TABLE public.userrecovery;
DROP SEQUENCE public.userfollow_id_seq;
DROP TABLE public.userfollow;
DROP SEQUENCE public.useremailverification_id_seq;
DROP TABLE public.useremailverification;
DROP SEQUENCE public.userblock_id_seq;
DROP TABLE public.userblock;
DROP SEQUENCE public.user_id_seq;
DROP TABLE public."user";
DROP SEQUENCE public.setting_id_seq;
DROP TABLE public.setting;
DROP SEQUENCE public.postusertag_id_seq;
DROP TABLE public.postusertag;
DROP SEQUENCE public.postsave_id_seq;
DROP TABLE public.postsave;
DROP SEQUENCE public.postlike_id_seq;
DROP TABLE public.postlike;
DROP SEQUENCE public.postcommentlike_id_seq;
DROP TABLE public.postcommentlike;
DROP SEQUENCE public.postcomment_id_seq;
DROP TABLE public.postcomment;
DROP SEQUENCE public.post_id_seq;
DROP TABLE public.post;
DROP SEQUENCE public.notification_id_seq;
DROP TABLE public.notification;
DROP SEQUENCE public.hashtagpost_id_seq;
DROP TABLE public.hashtagpost;
DROP SEQUENCE public.hashtagfollow_id_seq;
DROP TABLE public.hashtagfollow;
DROP SEQUENCE public.hashtag_id_seq;
DROP TABLE public.hashtag;
DROP SEQUENCE public.collection_id_seq;
DROP TABLE public.collection;
DROP SEQUENCE public.admin_id_seq;
DROP TABLE public.admin;
SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: admin; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.admin (
    id integer NOT NULL,
    username text,
    password text,
    meta_access text,
    meta_last_active timestamp without time zone,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.admin OWNER TO DATABASE_USERNAME;

--
-- Name: admin_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.admin_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admin_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: admin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.admin_id_seq OWNED BY public.admin.id;


--
-- Name: collection; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.collection (
    id integer NOT NULL,
    owner_user_id integer,
    display_title text,
    display_image text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.collection OWNER TO DATABASE_USERNAME;

--
-- Name: collection_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.collection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.collection_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: collection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.collection_id_seq OWNED BY public.collection.id;


--
-- Name: hashtag; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.hashtag (
    id integer NOT NULL,
    display_text text,
    cache_posts_count integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.hashtag OWNER TO DATABASE_USERNAME;

--
-- Name: hashtag_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.hashtag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.hashtag_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: hashtag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.hashtag_id_seq OWNED BY public.hashtag.id;


--
-- Name: hashtagfollow; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.hashtagfollow (
    id integer NOT NULL,
    followed_hashtag_id integer,
    followed_by_user_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.hashtagfollow OWNER TO DATABASE_USERNAME;

--
-- Name: hashtagfollow_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.hashtagfollow_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.hashtagfollow_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: hashtagfollow_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.hashtagfollow_id_seq OWNED BY public.hashtagfollow.id;


--
-- Name: hashtagpost; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.hashtagpost (
    id integer NOT NULL,
    hashtag_id integer,
    post_id integer,
    post_owner_user_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.hashtagpost OWNER TO DATABASE_USERNAME;

--
-- Name: hashtagpost_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.hashtagpost_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.hashtagpost_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: hashtagpost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.hashtagpost_id_seq OWNED BY public.hashtagpost.id;


--
-- Name: notification; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.notification (
    id integer NOT NULL,
    to_user_id integer,
    target_content_id integer,
    linked_content text,
    meta_type text,
    meta_is_read text,
    meta_is_transient text,
    stamp_registration_date date,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.notification OWNER TO DATABASE_USERNAME;

--
-- Name: notification_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notification_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.notification_id_seq OWNED BY public.notification.id;


--
-- Name: post; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.post (
    id integer NOT NULL,
    owner_user_id integer,
    display_caption text,
    display_location text,
    display_content text,
    meta_hashtags text,
    cache_likes_count integer,
    cache_comments_count integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.post OWNER TO DATABASE_USERNAME;

--
-- Name: post_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.post_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.post_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.post_id_seq OWNED BY public.post.id;


--
-- Name: postcomment; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.postcomment (
    id integer NOT NULL,
    owner_user_id integer,
    parent_post_id integer,
    reply_to_postcomment_id integer,
    display_text text,
    cache_likes_count integer,
    cache_comments_count integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.postcomment OWNER TO DATABASE_USERNAME;

--
-- Name: postcomment_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.postcomment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.postcomment_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: postcomment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.postcomment_id_seq OWNED BY public.postcomment.id;


--
-- Name: postcommentlike; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.postcommentlike (
    id integer NOT NULL,
    liked_by_user_id integer,
    liked_postcomment_id integer,
    parent_post_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.postcommentlike OWNER TO DATABASE_USERNAME;

--
-- Name: postcommentlike_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.postcommentlike_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.postcommentlike_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: postcommentlike_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.postcommentlike_id_seq OWNED BY public.postcommentlike.id;


--
-- Name: postlike; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.postlike (
    id integer NOT NULL,
    liked_post_id integer,
    liked_by_user_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.postlike OWNER TO DATABASE_USERNAME;

--
-- Name: postlike_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.postlike_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.postlike_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: postlike_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.postlike_id_seq OWNED BY public.postlike.id;


--
-- Name: postsave; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.postsave (
    id integer NOT NULL,
    saved_post_id integer,
    saved_by_user_id integer,
    saved_to_collection_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.postsave OWNER TO DATABASE_USERNAME;

--
-- Name: postsave_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.postsave_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.postsave_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: postsave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.postsave_id_seq OWNED BY public.postsave.id;


--
-- Name: postusertag; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.postusertag (
    id integer NOT NULL,
    tagged_user_id integer,
    tagged_in_post_id integer,
    post_owner_user_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.postusertag OWNER TO DATABASE_USERNAME;

--
-- Name: postusertag_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.postusertag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.postusertag_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: postusertag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.postusertag_id_seq OWNED BY public.postusertag.id;


--
-- Name: setting; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.setting (
    id integer NOT NULL,
    key text,
    value text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.setting OWNER TO DATABASE_USERNAME;

--
-- Name: setting_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.setting_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.setting_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: setting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.setting_id_seq OWNED BY public.setting.id;


--
-- Name: user; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public."user" (
    id integer NOT NULL,
    email text,
    username text,
    password text,
    display_name text,
    display_image text,
    display_bio text,
    display_web text,
    meta_access text,
    meta_is_private text,
    meta_is_email_verified text,
    meta_last_active timestamp without time zone,
    meta_push_settings text,
    cache_posts_count integer,
    cache_followers_count integer,
    cache_followings_count integer,
    cache_blocked_user_ids text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public."user" OWNER TO DATABASE_USERNAME;

--
-- Name: user_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.user_id_seq OWNED BY public."user".id;


--
-- Name: userblock; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.userblock (
    id integer NOT NULL,
    blocked_user_id integer,
    blocked_by_user_id integer,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.userblock OWNER TO DATABASE_USERNAME;

--
-- Name: userblock_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.userblock_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.userblock_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: userblock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.userblock_id_seq OWNED BY public.userblock.id;


--
-- Name: useremailverification; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.useremailverification (
    id integer NOT NULL,
    user_id integer,
    meta_access_otp integer,
    meta_times_failed integer,
    meta_is_expired text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.useremailverification OWNER TO DATABASE_USERNAME;

--
-- Name: useremailverification_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.useremailverification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.useremailverification_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: useremailverification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.useremailverification_id_seq OWNED BY public.useremailverification.id;


--
-- Name: userfollow; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.userfollow (
    id integer NOT NULL,
    followed_user_id integer,
    followed_by_user_id integer,
    meta_is_pending text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.userfollow OWNER TO DATABASE_USERNAME;

--
-- Name: userfollow_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.userfollow_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.userfollow_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: userfollow_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.userfollow_id_seq OWNED BY public.userfollow.id;


--
-- Name: userrecovery; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE public.userrecovery (
    id integer NOT NULL,
    user_id integer,
    meta_access_otp integer,
    meta_access_token text,
    meta_times_failed integer,
    meta_is_expired text,
    stamp_registration timestamp without time zone,
    stamp_last_update timestamp without time zone
);


ALTER TABLE public.userrecovery OWNER TO DATABASE_USERNAME;

--
-- Name: userrecovery_id_seq; Type: SEQUENCE; Schema: public; Owner: root
--

CREATE SEQUENCE public.userrecovery_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.userrecovery_id_seq OWNER TO DATABASE_USERNAME;

--
-- Name: userrecovery_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: root
--

ALTER SEQUENCE public.userrecovery_id_seq OWNED BY public.userrecovery.id;


--
-- Name: admin id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.admin ALTER COLUMN id SET DEFAULT nextval('public.admin_id_seq'::regclass);


--
-- Name: collection id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.collection ALTER COLUMN id SET DEFAULT nextval('public.collection_id_seq'::regclass);


--
-- Name: hashtag id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtag ALTER COLUMN id SET DEFAULT nextval('public.hashtag_id_seq'::regclass);


--
-- Name: hashtagfollow id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagfollow ALTER COLUMN id SET DEFAULT nextval('public.hashtagfollow_id_seq'::regclass);


--
-- Name: hashtagpost id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagpost ALTER COLUMN id SET DEFAULT nextval('public.hashtagpost_id_seq'::regclass);


--
-- Name: notification id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.notification ALTER COLUMN id SET DEFAULT nextval('public.notification_id_seq'::regclass);


--
-- Name: post id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.post ALTER COLUMN id SET DEFAULT nextval('public.post_id_seq'::regclass);


--
-- Name: postcomment id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postcomment ALTER COLUMN id SET DEFAULT nextval('public.postcomment_id_seq'::regclass);


--
-- Name: postcommentlike id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postcommentlike ALTER COLUMN id SET DEFAULT nextval('public.postcommentlike_id_seq'::regclass);


--
-- Name: postlike id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postlike ALTER COLUMN id SET DEFAULT nextval('public.postlike_id_seq'::regclass);


--
-- Name: postsave id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postsave ALTER COLUMN id SET DEFAULT nextval('public.postsave_id_seq'::regclass);


--
-- Name: postusertag id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postusertag ALTER COLUMN id SET DEFAULT nextval('public.postusertag_id_seq'::regclass);


--
-- Name: setting id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.setting ALTER COLUMN id SET DEFAULT nextval('public.setting_id_seq'::regclass);


--
-- Name: user id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public."user" ALTER COLUMN id SET DEFAULT nextval('public.user_id_seq'::regclass);


--
-- Name: userblock id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userblock ALTER COLUMN id SET DEFAULT nextval('public.userblock_id_seq'::regclass);


--
-- Name: useremailverification id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.useremailverification ALTER COLUMN id SET DEFAULT nextval('public.useremailverification_id_seq'::regclass);


--
-- Name: userfollow id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userfollow ALTER COLUMN id SET DEFAULT nextval('public.userfollow_id_seq'::regclass);


--
-- Name: userrecovery id; Type: DEFAULT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userrecovery ALTER COLUMN id SET DEFAULT nextval('public.userrecovery_id_seq'::regclass);

--
-- //////////////////////////////////////////////////////////   Data   /////////////////////////////////////////////////////////////
--

--
-- Data for Name: admin; Type: TABLE DATA; Schema: public; Owner: root
--

COPY public.admin (id, username, password, meta_access, meta_last_active, stamp_registration, stamp_last_update) FROM stdin;
1	admin	$2y$10$KLcALFiPyDBKsQ4EzMiEjuPRKG0YYPGzPlJtdGDo.jqZk9GNpnEZa	$2y$10$JNbyv4.ZC1Sdvrt2e24YQ.uD8lKVCaF3msikFK8S/R5JI9xKiuZpS	2022-04-15 07:48:47	2022-04-15 07:13:57	2022-04-15 07:48:47
\.

--
-- Data for Name: setting; Type: TABLE DATA; Schema: public; Owner: root
--

COPY public.setting (id, key, value, stamp_registration, stamp_last_update) FROM stdin;
1	setting_none	none	2022-04-15 07:13:57	2022-04-15 07:13:57
2	setting_max_len_user_username	50	2022-04-15 07:13:57	2022-04-15 07:13:57
3	setting_min_len_user_username	6	2022-04-15 07:13:57	2022-04-15 07:13:57
4	setting_max_len_user_email	250	2022-04-15 07:13:57	2022-04-15 07:13:57
5	setting_min_len_user_email	6	2022-04-15 07:13:57	2022-04-15 07:13:57
6	setting_max_len_user_password	100	2022-04-15 07:13:57	2022-04-15 07:13:57
7	setting_min_len_user_password	6	2022-04-15 07:13:57	2022-04-15 07:13:57
8	setting_max_len_user_display_name	100	2022-04-15 07:13:57	2022-04-15 07:13:57
9	setting_min_len_user_display_name	0	2022-04-15 07:13:57	2022-04-15 07:13:57
10	setting_max_len_user_display_bio	100	2022-04-15 07:13:57	2022-04-15 07:13:57
11	setting_min_len_user_display_bio	0	2022-04-15 07:13:57	2022-04-15 07:13:57
12	setting_max_len_user_display_web	100	2022-04-15 07:13:57	2022-04-15 07:13:57
13	setting_min_len_user_display_web	0	2022-04-15 07:13:57	2022-04-15 07:13:57
14	setting_max_user_display_image_file_size	10	2022-04-15 07:13:58	2022-04-15 07:13:58
15	setting_supported_user_display_image_file_format	png, jpg, jpeg, webp	2022-04-15 07:13:58	2022-04-15 07:13:58
16	setting_max_len_post_display_caption	3000	2022-04-15 07:13:58	2022-04-15 07:13:58
17	setting_min_len_post_display_caption	0	2022-04-15 07:13:58	2022-04-15 07:13:58
18	setting_max_len_post_display_location	100	2022-04-15 07:13:58	2022-04-15 07:13:58
19	setting_min_len_post_display_location	0	2022-04-15 07:13:58	2022-04-15 07:13:58
20	setting_max_post_display_content_item	12	2022-04-15 07:13:58	2022-04-15 07:13:58
21	setting_min_post_display_content_item	1	2022-04-15 07:13:58	2022-04-15 07:13:58
22	setting_max_post_hashtag	8	2022-04-15 07:13:58	2022-04-15 07:13:58
23	setting_min_post_hashtag	0	2022-04-15 07:13:58	2022-04-15 07:13:58
24	setting_max_len_post_hashtag	35	2022-04-15 07:13:58	2022-04-15 07:13:58
25	setting_min_len_post_hashtag	3	2022-04-15 07:13:58	2022-04-15 07:13:58
26	setting_max_post_user_tag_per_item	8	2022-04-15 07:13:58	2022-04-15 07:13:58
27	setting_min_post_user_tag_per_item	0	2022-04-15 07:13:58	2022-04-15 07:13:58
28	setting_max_post_user_tag_total	40	2022-04-15 07:13:58	2022-04-15 07:13:58
29	setting_min_post_user_tag_total	0	2022-04-15 07:13:58	2022-04-15 07:13:58
30	setting_max_post_display_content_item_file_size	5	2022-04-15 07:13:58	2022-04-15 07:13:58
31	setting_supported_post_display_content_item_file_format	png, jpg, jpeg, webp	2022-04-15 07:13:58	2022-04-15 07:13:58
32	setting_max_len_post_comment_display_text	1500	2022-04-15 07:13:58	2022-04-15 07:13:58
33	setting_min_len_post_comment_display_text	1	2022-04-15 07:13:58	2022-04-15 07:13:58
34	setting_max_len_collection_display_title	50	2022-04-15 07:13:58	2022-04-15 07:13:58
35	setting_min_len_collection_display_title	1	2022-04-15 07:13:58	2022-04-15 07:13:58
36	ss_text_name	Photogram	2022-04-15 07:13:58	2022-04-15 07:13:58
37	ss_text_minimum_api_version	0.1	2022-04-15 07:13:58	2022-04-15 07:13:58
38	ss_text_api_update_message	Whoa! you're missing plenty of new features. Update your app.	2022-04-15 07:13:58	2022-04-15 07:13:58
39	ss_text_api_ios_update_url	https://address.to.update.for.ios.devices	2022-04-15 07:13:58	2022-04-15 07:13:58
40	ss_text_api_android_update_url	https://address.to.update.for.android.devices	2022-04-15 07:13:58	2022-04-15 07:13:58
41	ss_int_otp_lifetime_in_hours	2	2022-04-15 07:13:58	2022-04-15 07:13:58
42	ss_int_otp_lifetime_in_tries	5	2022-04-15 07:13:58	2022-04-15 07:13:58
43	ss_text_mailer_contact_email	contact@yoursite.com	2022-04-15 07:13:58	2022-04-15 07:13:58
44	ss_text_mailer_no_reply_email	noreply@yoursite.com	2022-04-15 07:13:58	2022-04-15 07:13:58
45	ss_bool_mailer_smtp	1	2022-04-15 07:13:58	2022-04-15 07:13:58
46	ss_text_mailer_smtp_host	smtp.gmail.com	2022-04-15 07:13:58	2022-04-15 07:13:58
47	ss_int_mailer_smtp_port	465	2022-04-15 07:13:58	2022-04-15 07:13:58
48	ss_text_mailer_smtp_username	email@gmail.com	2022-04-15 07:13:58	2022-04-15 07:13:58
49	ss_text_mailer_smtp_password	gmails acc password	2022-04-15 07:13:58	2022-04-15 07:13:58
50	ss_text_email_header	#e1e1e1	2022-04-15 07:13:58	2022-04-15 07:13:58
51	ss_text_email_footer		2022-04-15 07:13:58	2022-04-15 07:13:58
52	ss_text_path_uploads	/var/www/html/photogram//uploads/	2022-04-15 07:13:58	2022-04-15 07:13:58
53	ss_text_file_name_placeholder_user	user.png	2022-04-15 07:13:58	2022-04-15 07:13:58
54	ss_text_file_name_placeholder_post	post.png	2022-04-15 07:13:58	2022-04-15 07:13:58
55	ss_text_file_name_placeholder_collection	collection.png	2022-04-15 07:13:58	2022-04-15 07:13:58
56	ss_bool_implicit_hashtag_follow_on_post_like	1	2022-04-15 07:13:58	2022-04-15 07:13:58
57	ss_bool_implicit_hashtag_follow_on_post_comment	1	2022-04-15 07:13:58	2022-04-15 07:13:58
58	ss_bool_implicit_hashtag_follow_on_post_comment_reply	1	2022-04-15 07:13:58	2022-04-15 07:13:58
59	ss_int_limit_load_collection	6	2022-04-15 07:13:58	2022-04-15 07:13:58
60	ss_int_limit_load_user_follow	9	2022-04-15 07:13:58	2022-04-15 07:13:58
61	ss_int_limit_load_user_follow_pending	9	2022-04-15 07:13:58	2022-04-15 07:13:58
62	ss_int_limit_load_user_block	9	2022-04-15 07:13:58	2022-04-15 07:13:58
63	ss_int_limit_load_hashtag_post	9	2022-04-15 07:13:58	2022-04-15 07:13:58
64	ss_int_limit_load_hashtag_post_explore	9	2022-04-15 07:13:58	2022-04-15 07:13:58
65	ss_int_limit_load_post_comment_like	9	2022-04-15 07:13:58	2022-04-15 07:13:58
66	ss_int_limit_load_post_comment	3	2022-04-15 07:13:58	2022-04-15 07:13:58
67	ss_int_limit_load_post_like	9	2022-04-15 07:13:58	2022-04-15 07:13:58
68	ss_int_limit_load_post_save	6	2022-04-15 07:13:58	2022-04-15 07:13:58
69	ss_int_limit_load_post_user_tag	6	2022-04-15 07:13:58	2022-04-15 07:13:58
70	ss_int_limit_load_post_news_feeds	6	2022-04-15 07:13:58	2022-04-15 07:13:58
71	ss_int_limit_load_post_profile	9	2022-04-15 07:13:58	2022-04-15 07:13:58
72	ss_int_limit_load_user_search	9	2022-04-15 07:13:58	2022-04-15 07:13:58
73	ss_int_limit_load_notification	9	2022-04-15 07:13:58	2022-04-15 07:13:58
74	ss_int_limit_load_post_infinite	12	2022-04-15 07:13:58	2022-04-15 07:13:58
76	ss_enum_user_default_account_privacy	no	2022-04-15 07:13:58	2022-04-15 07:13:58
77	ss_enum_notification_pause_all	off	2022-04-15 07:13:58	2022-04-15 07:13:58
78	ss_enum_notification_likes	from_everyone	2022-04-15 07:13:58	2022-04-15 07:13:58
79	ss_enum_notification_comments	from_everyone	2022-04-15 07:13:58	2022-04-15 07:13:58
80	ss_enum_notification_photos_of_you	from_everyone	2022-04-15 07:13:58	2022-04-15 07:13:58
81	ss_enum_notification_likes_on_photos_of_you	on	2022-04-15 07:13:58	2022-04-15 07:13:58
82	ss_enum_notification_comments_on_photos_of_you	on	2022-04-15 07:13:58	2022-04-15 07:13:58
83	ss_enum_notification_comment_likes_and_pins	on	2022-04-15 07:13:58	2022-04-15 07:13:58
84	ss_enum_notification_accepted_follow_request	on	2022-04-15 07:13:58	2022-04-15 07:13:58
85	ss_int_compress_user_display_image_file_res	150	2022-04-15 07:13:58	2022-04-15 07:13:58
86	ss_int_compress_post_display_image_file_res	400	2022-04-15 07:13:58	2022-04-15 07:13:58
87	ss_int_compress_collection_cover_image_file_res	200	2022-04-15 07:13:58	2022-04-15 07:13:58
88	ss_int_compress_user_display_image_file_quality	90	2022-04-15 07:13:58	2022-04-15 07:13:58
89	ss_int_compress_post_display_image_file_quality	90	2022-04-15 07:13:58	2022-04-15 07:13:58
90	ss_int_compress_collection_cover_image_file_quality	70	2022-04-15 07:13:58	2022-04-15 07:13:58
91	ss_enum_storage_disk_user_images	local	2022-04-15 07:13:58	2022-04-15 07:13:58
92	ss_enum_storage_disk_post_images	local	2022-04-15 07:13:58	2022-04-15 07:13:58
93	ss_enum_storage_disk_collection_images	local	2022-04-15 07:13:58	2022-04-15 07:13:58
94	ss_text_aws_s3_key		2022-04-15 07:13:58	2022-04-15 07:13:58
95	ss_text_aws_s3_secret		2022-04-15 07:13:58	2022-04-15 07:13:58
96	ss_text_aws_s3_bucket		2022-04-15 07:13:58	2022-04-15 07:13:58
97	ss_text_aws_s3_region		2022-04-15 07:13:58	2022-04-15 07:13:58
98	ss_text_azure_blob_dsn		2022-04-15 07:13:58	2022-04-15 07:13:58
99	ss_text_azure_blob_container		2022-04-15 07:13:58	2022-04-15 07:13:58
100	ss_text_wasabi_s3_key		2022-04-15 07:13:58	2022-04-15 07:13:58
101	ss_text_wasabi_s3_secret		2022-04-15 07:13:58	2022-04-15 07:13:58
102	ss_text_wasabi_s3_bucket		2022-04-15 07:13:58	2022-04-15 07:13:58
103	ss_text_wasabi_s3_region		2022-04-15 07:13:58	2022-04-15 07:13:58
75	ss_bool_user_email_verification	0	2022-04-15 07:13:58	2022-04-15 07:48:45
\.

--
-- Name: admin_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.admin_id_seq', 1, true);


--
-- Name: collection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.collection_id_seq', 1, true);


--
-- Name: hashtag_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.hashtag_id_seq', 369, true);


--
-- Name: hashtagfollow_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.hashtagfollow_id_seq', 91, true);


--
-- Name: hashtagpost_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.hashtagpost_id_seq', 580, true);


--
-- Name: notification_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.notification_id_seq', 15, true);


--
-- Name: post_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.post_id_seq', 145, true);


--
-- Name: postcomment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.postcomment_id_seq', 2772, true);


--
-- Name: postcommentlike_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.postcommentlike_id_seq', 1, true);


--
-- Name: postlike_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.postlike_id_seq', 876, true);


--
-- Name: postsave_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.postsave_id_seq', 18, true);


--
-- Name: postusertag_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.postusertag_id_seq', 782, true);


--
-- Name: setting_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.setting_id_seq', 103, true);


--
-- Name: user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.user_id_seq', 29, true);


--
-- Name: userblock_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.userblock_id_seq', 1, true);


--
-- Name: useremailverification_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.useremailverification_id_seq', 1, true);


--
-- Name: userfollow_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.userfollow_id_seq', 348, true);


--
-- Name: userrecovery_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval('public.userrecovery_id_seq', 1, true);


--
-- Name: admin admin_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.admin
    ADD CONSTRAINT admin_pkey PRIMARY KEY (id);


--
-- Name: collection collection_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.collection
    ADD CONSTRAINT collection_pkey PRIMARY KEY (id);


--
-- Name: hashtag hashtag_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtag
    ADD CONSTRAINT hashtag_pkey PRIMARY KEY (id);


--
-- Name: hashtagfollow hashtagfollow_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagfollow
    ADD CONSTRAINT hashtagfollow_pkey PRIMARY KEY (id);


--
-- Name: hashtagpost hashtagpost_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagpost
    ADD CONSTRAINT hashtagpost_pkey PRIMARY KEY (id);


--
-- Name: notification notification_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.notification
    ADD CONSTRAINT notification_pkey PRIMARY KEY (id);


--
-- Name: post post_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.post
    ADD CONSTRAINT post_pkey PRIMARY KEY (id);


--
-- Name: postcomment postcomment_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postcomment
    ADD CONSTRAINT postcomment_pkey PRIMARY KEY (id);


--
-- Name: postcommentlike postcommentlike_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postcommentlike
    ADD CONSTRAINT postcommentlike_pkey PRIMARY KEY (id);


--
-- Name: postlike postlike_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postlike
    ADD CONSTRAINT postlike_pkey PRIMARY KEY (id);


--
-- Name: postsave postsave_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postsave
    ADD CONSTRAINT postsave_pkey PRIMARY KEY (id);


--
-- Name: postusertag postusertag_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.postusertag
    ADD CONSTRAINT postusertag_pkey PRIMARY KEY (id);


--
-- Name: setting setting_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.setting
    ADD CONSTRAINT setting_pkey PRIMARY KEY (id);


--
-- Name: user user_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (id);


--
-- Name: userblock userblock_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userblock
    ADD CONSTRAINT userblock_pkey PRIMARY KEY (id);


--
-- Name: useremailverification useremailverification_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.useremailverification
    ADD CONSTRAINT useremailverification_pkey PRIMARY KEY (id);


--
-- Name: userfollow userfollow_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userfollow
    ADD CONSTRAINT userfollow_pkey PRIMARY KEY (id);


--
-- Name: userrecovery userrecovery_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userrecovery
    ADD CONSTRAINT userrecovery_pkey PRIMARY KEY (id);


--
-- Name: index_foreignkey_collection_owner_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_collection_owner_user ON public.collection USING btree (owner_user_id);


--
-- Name: index_foreignkey_hashtagfollow_followed_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_hashtagfollow_followed_by_user ON public.hashtagfollow USING btree (followed_by_user_id);


--
-- Name: index_foreignkey_hashtagfollow_followed_hashtag; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_hashtagfollow_followed_hashtag ON public.hashtagfollow USING btree (followed_hashtag_id);


--
-- Name: index_foreignkey_hashtagpost_hashtag; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_hashtagpost_hashtag ON public.hashtagpost USING btree (hashtag_id);


--
-- Name: index_foreignkey_hashtagpost_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_hashtagpost_post ON public.hashtagpost USING btree (post_id);


--
-- Name: index_foreignkey_hashtagpost_post_owner_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_hashtagpost_post_owner_user ON public.hashtagpost USING btree (post_owner_user_id);


--
-- Name: index_foreignkey_notification_target_content; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_notification_target_content ON public.notification USING btree (target_content_id);


--
-- Name: index_foreignkey_notification_to_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_notification_to_user ON public.notification USING btree (to_user_id);


--
-- Name: index_foreignkey_post_owner_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_post_owner_user ON public.post USING btree (owner_user_id);


--
-- Name: index_foreignkey_postcomment_owner_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcomment_owner_user ON public.postcomment USING btree (owner_user_id);


--
-- Name: index_foreignkey_postcomment_parent_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcomment_parent_post ON public.postcomment USING btree (parent_post_id);


--
-- Name: index_foreignkey_postcomment_reply_to_postcomment; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcomment_reply_to_postcomment ON public.postcomment USING btree (reply_to_postcomment_id);


--
-- Name: index_foreignkey_postcommentlike_liked_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcommentlike_liked_by_user ON public.postcommentlike USING btree (liked_by_user_id);


--
-- Name: index_foreignkey_postcommentlike_liked_postcomment; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcommentlike_liked_postcomment ON public.postcommentlike USING btree (liked_postcomment_id);


--
-- Name: index_foreignkey_postcommentlike_parent_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postcommentlike_parent_post ON public.postcommentlike USING btree (parent_post_id);


--
-- Name: index_foreignkey_postlike_liked_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postlike_liked_by_user ON public.postlike USING btree (liked_by_user_id);


--
-- Name: index_foreignkey_postlike_liked_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postlike_liked_post ON public.postlike USING btree (liked_post_id);


--
-- Name: index_foreignkey_postsave_saved_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postsave_saved_by_user ON public.postsave USING btree (saved_by_user_id);


--
-- Name: index_foreignkey_postsave_saved_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postsave_saved_post ON public.postsave USING btree (saved_post_id);


--
-- Name: index_foreignkey_postsave_saved_to_collection; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postsave_saved_to_collection ON public.postsave USING btree (saved_to_collection_id);


--
-- Name: index_foreignkey_postusertag_post_owner_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postusertag_post_owner_user ON public.postusertag USING btree (post_owner_user_id);


--
-- Name: index_foreignkey_postusertag_tagged_in_post; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postusertag_tagged_in_post ON public.postusertag USING btree (tagged_in_post_id);


--
-- Name: index_foreignkey_postusertag_tagged_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_postusertag_tagged_user ON public.postusertag USING btree (tagged_user_id);


--
-- Name: index_foreignkey_userblock_blocked_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_userblock_blocked_by_user ON public.userblock USING btree (blocked_by_user_id);


--
-- Name: index_foreignkey_userblock_blocked_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_userblock_blocked_user ON public.userblock USING btree (blocked_user_id);


--
-- Name: index_foreignkey_useremailverification_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_useremailverification_user ON public.useremailverification USING btree (user_id);


--
-- Name: index_foreignkey_userfollow_followed_by_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_userfollow_followed_by_user ON public.userfollow USING btree (followed_by_user_id);


--
-- Name: index_foreignkey_userfollow_followed_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_userfollow_followed_user ON public.userfollow USING btree (followed_user_id);


--
-- Name: index_foreignkey_userrecovery_user; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX index_foreignkey_userrecovery_user ON public.userrecovery USING btree (user_id);


--
-- Name: hashtagpost hashtagpost_hashtag_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagpost
    ADD CONSTRAINT hashtagpost_hashtag_id_fkey FOREIGN KEY (hashtag_id) REFERENCES public.hashtag(id) ON UPDATE SET NULL ON DELETE SET NULL DEFERRABLE;


--
-- Name: hashtagpost hashtagpost_post_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.hashtagpost
    ADD CONSTRAINT hashtagpost_post_id_fkey FOREIGN KEY (post_id) REFERENCES public.post(id) ON UPDATE SET NULL ON DELETE SET NULL DEFERRABLE;


--
-- Name: useremailverification useremailverification_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.useremailverification
    ADD CONSTRAINT useremailverification_user_id_fkey FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE SET NULL ON DELETE SET NULL DEFERRABLE;


--
-- Name: userrecovery userrecovery_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY public.userrecovery
    ADD CONSTRAINT userrecovery_user_id_fkey FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE SET NULL ON DELETE SET NULL DEFERRABLE;


--
-- PostgreSQL database dump complete
--

